;/*************************************************
; Program		:use 8bit I/O of PCF8574A as output port.
; Description	:Let LEDs  connect to 8 bits  I/O of PCF8574A to 
;				:display port's condition.
; CPU Control	:90S8535
; File name		:P8574aout.asm
; Assembler		:AVR Studio 4.05
; 
;**************************************************

.include "8535def.inc"

			.org   	$000 
    		rjmp  reset			;Reset Handle
;/************************
; Define Register
;/************************
.def		counter1  	= r16
.def		counter2	= r17
.def		counter3	= r18
.def		temp		= r19
.def		data		= r21
;/***********************
; Define I/O Port,Pin
;/***********************
.equ		SCL		= 0
.equ		SDA		= 1
.equ		I2CIO_ADRW	= 0x70
.equ		I2CIO_ADRR	= 0x71
;/*******************
; Main Program
;/*******************
reset:      ldi	temp,low(RAMEND)
            out	SPL,temp          	;init Stack Pointer     
            ldi	temp,high(RAMEND)
            out	SPH,temp        	
PCF8574A:	ser	temp
			out	DDRC,temp
			out	PORTC,temp
			ldi	temp,0xFE

Rotate_Left:	
			rcall	PCF8574A_wr
			rcall	delay200ms
			cpi	temp,0x7F
			breq	Rotate_Right
			sec
			rol	temp
			rjmp	Rotate_Left

Rotate_Right:	
			sec
			ror	temp
			cpi	temp,0xFE
			breq	Rotate_Left
			rcall	PCF8574A_wr
			rcall	delay200ms
			rjmp	Rotate_Right

;/********************
; Write 1 byte 
;/********************
PCF8574A_wr:	
			rcall	I2C_Start
			ldi	data,I2CIO_ADRW
			rcall	out
			mov	data,temp
			rcall	out		
			ret

;/*********************
; I2C start statement 
;/*********************
I2C_Start:	
			sbi	PORTC,SDA
			sbi	PORTC,SCL
			rcall	I2C_delay
			cbi	PORTC,SDA
			rcall	I2C_delay
			cbi	PORTC,SCL
			ret

;/********************
; I2C stop statement
;/********************
I2C_Stop:	cbi	PORTC,SDA
			rcall	I2C_delay
			sbi	PORTC,SCL
			rcall	I2C_delay
			sbi	PORTC,SDA
			ret

;/*******************************
; write 8 bit data to SDA line
;/*******************************
out:		push	data
			ldi	counter1,8			;8 bit  data
out1:		sbi	PORTC,SDA		 
			rol	data
			brcs	out2			;if c flag=1 set SDA line else clear SDA line
			cbi	PORTC,SDA
out2:		nop
			sbi	PORTC,SCL
			rcall	I2C_delay
			cbi	PORTC,SCL
			rcall	I2C_delay
			dec	counter1
			brne	out1
			sbi	PORTC,SDA
			nop
			sbi	PORTC,SCL
			rcall	I2C_delay
			sbic	PINC,SDA		;if SDA line=1,begin write old data again
			rjmp	out3
			cbi	PORTC,SCL
			pop	data
			ret
out3:		pop	data
			rjmp	out

;/********************************
; receive data from SDA line
;/******************************** 
in:			push	counter1
			ldi	counter1,8			;8 bit data
			sbi	PORTC,SDA			;set SDA line for receiving new data
in1:		nop
			sbi	PORTC,SCL
			sec
			sbis	PINC,SDA		;set c flag when SDA line = 1
			clc
			rol	data				;rotate left
			cbi	PORTC,SCL
			rcall	I2C_delay
			dec	counter1
			brne	in1			
			sbi	PORTC,SDA			;send Acknowledge bit
			nop
			sbi	PORTC,SCL
			rcall	I2C_delay
			cbi	PORTC,SCL
			pop	counter1
			ret

;/*****************
; delay time
;/*****************
I2C_delay:	push	counter1
			ldi    	counter1,5
I2C_delay_1: 	
			dec    	counter1
            brne   	I2C_delay_1
			pop	counter1
			ret          

delay1ms:	push	counter1
			push	counter2
			ldi	counter1,8
delay1ms_1: ldi counter2,250
delay1ms_2: nop
			dec counter2
            brne   	delay1ms_2
            dec    	counter1
            brne   	delay1ms_1
            pop	counter2
			pop	counter1
			ret          

delay200ms:	push	counter3
			ldi	counter3,200
delay200ms_1:	
			rcall	delay1ms
			dec	counter3
			brne	delay200ms_1
			pop	counter3
			ret
          	 